#!/bin/sh

set -e

if [ -f /config/dropbear ] ; then
    rm -r /config/dropbear
fi

if [ -f /config/scanfreqdone ]; then
    rm -f /config/scanfreqdone
fi

if [ -d /var/lib/warranty ]; then
	rm -rf /var/lib/warranty > /dev/null 2>&1
fi

if [ -f fw.md5 ]; then
	echo "Verifying md5 checksums"
    md5sum -s -c fw.md5 > /dev/null 2>&1
fi

if [ -e BOOT.bin ]; then
	echo "Updating BOOT.bin"
	flash_erase /dev/mtd0 0x0 0x40 > /dev/null 2>&1
	nandwrite -p -s 0x0 /dev/mtd0 BOOT.bin > /dev/null 2>&1
fi

if [ -e devicetree.dtb ]; then
	echo "Updating devicetree.dtb"
	flash_erase /dev/mtd0 0x1A00000 0x1 > /dev/null 2>&1
	nandwrite -p -s 0x1A00000 /dev/mtd0 devicetree.dtb > /dev/null 2>&1
fi

if [ -e uImage ]; then
	echo "Updating uImage"
	flash_erase /dev/mtd0 0x2000000 0x40 > /dev/null 2>&1
	nandwrite -p -s 0x2000000 /dev/mtd0 uImage > /dev/null 2>&1
fi

if [ -e uramdisk.image.gz ]; then
	echo "Updating uramdisk.image.gz"
	flash_erase /dev/mtd1 0x0 0x100 >/dev/null 2>&1
	nandwrite -p -s 0x0 /dev/mtd1 uramdisk.image.gz > /dev/null 2>&1
	if [ -e /dev/mtd4 ]; then
		flash_erase /dev/mtd4 0x0 0x100 >/dev/null 2>&1
		nandwrite -p -s 0x0 /dev/mtd4 uramdisk.image.gz > /dev/null 2>&1
	fi
fi

if [ -e anthill.tar.gz ]; then
    ANTHILLDIR=/opt/anthill

    if [ -d /nvdata ]; then
        ANTHILLDIR=/nvdata/$ANTHILLDIR
    fi

	echo "Installing anthill agent"
    mkdir -p $ANTHILLDIR > /dev/null 2>&1
    rm -rf $ANTHILLDIR/* > /dev/null 2>&1
    tar -xzf anthill.tar.gz -C $ANTHILLDIR > /dev/null 2>&1
fi

if [ -f apikeys.json ]; then
	if [ ! -f /config/apikeys.json ]; then
		echo "Copying API keys"
		cp apikeys.json /config > /dev/null 2>&1
	fi
fi

if [ -f anthill.json ]; then
    if [ ! -f /config/anthill.json ]; then
		echo "Copying anthill API key"
        cp anthill.json /config > /dev/null 2>&1
    fi
fi

sync